<?php
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

require_once "../includes/config.php";
require_once "../includes/functions.php";

/* ============= RESTAURANT BY FOLDER ============= */
$folder = basename(dirname(__FILE__));
$restaurant = get_restaurant($folder);
if(!$restaurant) die("Restaurant Not Found");

/* ================= LANGUAGE ================== */
$lang = $_GET['lang'] ?? ($_SESSION['lang'] ?? "ar");
$_SESSION['lang'] = $lang;
include "lang/{$lang}.php";

/* ================= BRANCHES ================== */
$sql = "SELECT * FROM branches WHERE restaurant_id = ? AND active = 1 ORDER BY ordering ASC";
$stmt = db()->prepare($sql);
$stmt->execute([$restaurant['id']]);
$branches = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ================= SOCIAL MODE ================= */
$social_mode = $restaurant['social_mode'] ?? "same";

if($social_mode == "same"){
    // روابط عامة لكل الفروع
    $social_links = fetch_all("SELECT * FROM restaurant_social WHERE restaurant_id=? AND active=1 ORDER BY ordering ASC", [$restaurant['id']]);
}

/* ================= STYLE COLORS ================= */
$primary_color = $restaurant['secondary_color'] ?? "#ff7a00";
?>

<!DOCTYPE html>
<html lang="<?= $lang ?>" dir="<?= $lang=='ar'?'rtl':'ltr' ?>">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title><?= $restaurant['name_'.$lang] ?? $restaurant['name'] ?></title>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">

<style>
body{
    margin:0;
    background:#000;
    color:#fff;
    font-family:'Tajawal',sans-serif;
    overflow-x:hidden;
}

/* ================= HEADER (Full Background) ================= */
.header{
    width:100%;
    min-height:260px;
    position:relative;
    z-index:2;
}


/* خلفية فيديو أو صورة (عام للصفحة) */
.bg{
    width:100%;
    height:100%;
    object-fit:cover;
    position:fixed;
    top:0; left:0;
    z-index:0;
}

/* طبقة التعتيم فوق الخلفية */
.overlay{
    position:fixed;
    width:100%;
    height:100%;
    top:0; left:0;
    background:rgba(0,0,0,.55);
    backdrop-filter: blur(2px);
    z-index:1;
}


/* الشعار */
.header .logo{
    position:absolute;
    bottom:60px;
    left:50%;
    transform:translateX(-50%);
    width:150px;
    z-index:2;
}

/* تغيير اللغة */
.lang-switch{
    position:absolute;
    bottom:10px;
    left:50%;
    transform:translateX(-50%);
    display:flex;
    gap:8px;
    z-index:2;
}

.lang-switch a{
    padding:6px 12px;
    border:1px solid <?= $primary_color ?>;
    color:<?= $primary_color ?>;
    border-radius:14px;
    font-size:13px;
    background:rgba(0,0,0,0.45);
    backdrop-filter:blur(3px);
}

/* ================= CONTENT ================= */
.main{
    padding:60px 20px;
    position:relative;
    z-index:3;
    background:transparent;
}

/* ================= BRANCH CARD (Blur Style) ================= */
.branch-card{
    background:rgba(18,18,18,0.55);
    backdrop-filter:blur(8px);
    border:1px solid rgba(255,255,255,0.08);
    border-radius:16px;
    padding:22px 20px;
    margin-bottom:22px;
    box-shadow:0 0 18px rgba(0,0,0,0.45);
}

.branch-title{
    font-size:22px;
    font-weight:bold;
    color:<?= $primary_color ?>;
}

.branch-slogan{
    font-size:16px;
    color:#ddd;
    margin-top:5px;
}

/* ================= SOCIAL ICONS ================= */
.social-row{ margin-top:14px; }

.social-row a{
    display:inline-block;
    background:rgba(0,0,0,0.55);
    padding:8px;
    margin:0 6px 6px 0;
    border-radius:50%;
    color:#fff;
    border:1px solid rgba(255,255,255,0.1);
}

.social-row i{
    font-size:22px;
}

/* ================= PHONES ================= */
.phone-row{
    margin-top:14px;
    color:#ccc;
    font-size:16px;
}

/* ================= BUTTONS ================= */
.btn-map,
.btn-menu{
    display:block;
    padding:12px 20px;
    width:60%;
    text-align:center;
    border-radius:10px;
    font-weight:bold;
    font-size:16px;
    margin:18px auto 0 auto;
}

.btn-map{
    background:rgba(255,255,255,0.15);
    color:#fff;
    backdrop-filter:blur(4px);
    border:1px solid rgba(255,255,255,0.18);
}

.btn-menu{
    background:<?= $primary_color ?>;
    color:#000;
}

.branches-grid{
    display:grid;
    gap:22px;
    grid-template-columns:repeat(1,1fr);
}

@media(min-width:768px){
    .branches-grid{
        grid-template-columns:repeat(4,1fr);
    }
}

</style>
</head>
<body>

<!-- GLOBAL BACKGROUND -->
<?php if($restaurant['background_video']): ?>
<video class="bg" autoplay muted loop playsinline>
    <source src="/menu/uploads/Videos/<?= htmlspecialchars($restaurant['background_video']) ?>" type="video/mp4">
</video>
<?php elseif($restaurant['background_image']): ?>
<img class="bg" src="/menu/uploads/MenuBG/<?= htmlspecialchars($restaurant['background_image']) ?>">
<?php endif; ?>
<div class="overlay"></div>

<!-- HEADER (Logo + Lang Only) -->
<div class="header" style="min-height:260px;">

    <?php if($restaurant['logo']): ?>
        <img class="logo" src="/menu/uploads/Logo/<?= htmlspecialchars($restaurant['logo']) ?>">
    <?php endif; ?>

    <!-- Language Switch -->
    <div class="lang-switch">
        <a href="?lang=ar">العربية</a>
        <a href="?lang=en">English</a>
        <a href="?lang=ku">کوردی</a>
    </div>
</div>

<!-- MAIN -->
<div class="main">

<div class="branches-grid">
<?php foreach($branches as $b): ?>
<?php if($social_mode=="custom"){ $social_links = fetch_all("SELECT * FROM branch_social WHERE branch_id=? AND active=1 ORDER BY ordering", [$b['id']]); } ?>
<div class="branch-card">

    <div class="branch-title"><?= $b["name_{$lang}"] ?: $b['name'] ?></div>
    <div class="branch-slogan"><?= $b['address'] ?></div>

    <!-- SOCIAL -->
    <div class="social-row">
        <?php foreach($social_links as $s): ?>
        <a href="<?= $s['url'] ?>" target="_blank"><i class="<?= $s['icon'] ?>"></i></a>
        <?php endforeach; ?>

       
    </div>

   <!-- PHONE -->
<div class="phone-row">
    <?php
    $phones = $b['phone'];

    // إذا كان JSON نفكّه
    if ($phones && ($decoded = json_decode($phones, true)) && is_array($decoded)) {
        $phones_list = $decoded;
    } else {
        // طريقة قديمة (مفصولة بفاصلة)
        $phones_list = explode(",", $phones);
    }

    foreach ($phones_list as $p):
        $p = trim($p);
        if(!$p) continue;

        // إزالة المسافات والأحرف غير الأرقام
        $clean = preg_replace("/[^0-9]/", "", $p);

        // إضافة +964 إذا لم يكن هناك كود دولة
        if (strpos($clean, "964") !== 0) {
            $clean = "964".$clean;
        }
    ?>
        <div>
            <a href="tel:+<?= $clean ?>" style="color:#fff;text-decoration:none;">
                📞 <?= $p ?>
            </a>
        </div>
    <?php endforeach; ?>
</div>


    <?php if($b['map_url']): ?>
    <a class="btn-map" href="<?= $b['map_url'] ?>" target="_blank"><?= $lang=='ar'?'الخريطة':'Map' ?></a>
    <?php endif; ?>

    <a class="btn-menu" href="menu.php?branch=<?= $b['id'] ?>&lang=<?= $lang ?>">
        <?= $lang=='ar'?'عرض المنيو':'View Menu' ?>
    </a>

</div>
<?php endforeach; ?>
</div>

</div>

</body>
</html>
