<?php
require_once "../includes/config.php";
require_once "../includes/functions.php";

header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"), true);

$item_id   = $data['item_id']   ?? null;
$branch_id = $data['branch_id'] ?? null;

if (!$item_id || !$branch_id) {
    echo json_encode(["success"=>false, "msg"=>"Missing params"]);
    exit;
}

$old_count = get_item_likes($item_id, $branch_id);
$new_count = toggle_like($item_id, $branch_id);

echo json_encode([
    "success" => true,
    "old_likes" => $old_count,
    "likes" => $new_count
]);
