<?php
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

/* =========================
   CORE
========================= */
require_once __DIR__ . "/../includes/db.php";
require_once __DIR__ . "/../includes/functions.php";

/* =========================
   LANGUAGE (FROM URL)
========================= */
$lang = $_GET['lang'] ?? 'ar';
if(!in_array($lang,['ar','en','ku'])) $lang = 'ar';
$dir = ($lang === 'ar') ? 'rtl' : 'ltr';

/* =========================
   TRANSLATIONS (SAFE)
========================= */
$tr = require __DIR__."/lang/$lang.php";
if(!is_array($tr)) $tr = [];

/* =========================
   GET RESERVATION
========================= */
$reservation_id = $_GET['id'] ?? null;
if(!$reservation_id) die("Reservation ID missing");

$reservation = fetch_one("
    SELECT * FROM reservations WHERE id=?
",[$reservation_id]);

if(!$reservation) die("Reservation not found");

/* =========================
   ITEMS
========================= */
$items = fetch_all("
    SELECT ri.*, i.name_ar, i.name_en, i.name_ku
    FROM reservation_items ri
    JOIN items i ON i.id = ri.item_id
    WHERE ri.reservation_id=?
",[$reservation_id]);
?>
<!DOCTYPE html>
<html lang="<?= $lang ?>" dir="<?= $dir ?>">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= $tr['reservation_success'] ?? 'Reservation Confirmed' ?></title>

<style>
body{
    margin:0;
    background:#111;
    color:#fff;
    font-family:Tajawal,sans-serif;
}
.container{
    max-width:700px;
    margin:auto;
    padding:24px;
    text-align:center;
}
.success{
    font-size:64px;
    color:#4CAF50;
    margin-bottom:10px;
}
h1{color:#ff7a00}
.card{
    background:#1c1c1c;
    border:1px solid #333;
    border-radius:14px;
    padding:20px;
    margin-top:20px;
    text-align:right;
}
.item{
    display:flex;
    justify-content:space-between;
    border-bottom:1px solid #333;
    padding:8px 0;
}
.total{
    font-size:20px;
    font-weight:bold;
    color:#ff7a00;
    margin-top:12px;
    text-align:left;
}
.btn{
    display:block;
    margin-top:24px;
    padding:14px;
    border-radius:10px;
    background:#ff7a00;
    color:#000;
    text-decoration:none;
    font-size:16px;
}
</style>
</head>

<body>
<div class="container">

<div class="success">✓</div>

<h1><?= $tr['reservation_success'] ?? 'Reservation Confirmed' ?></h1>

<p>
<?= $tr['thank_you'] ?? 'Thank you. Your reservation has been successfully submitted.' ?>
</p>

<div class="card">

<p><strong><?= $tr['reservation_number'] ?? 'Reservation Number' ?>:</strong> #<?= $reservation['id'] ?></p>
<p><strong><?= $tr['date'] ?? 'Date' ?>:</strong> <?= htmlspecialchars($reservation['reservation_date']) ?></p>
<p><strong><?= $tr['time'] ?? 'Time' ?>:</strong> <?= htmlspecialchars($reservation['reservation_time']) ?></p>
<p><strong><?= $tr['status'] ?? 'Status' ?>:</strong> <?= htmlspecialchars($reservation['status']) ?></p>

<hr style="border-color:#333">

<?php foreach($items as $it): ?>
<div class="item">
    <span>
        <?= $it["name_$lang"] ?? $it['name_ar'] ?>
        × <?= $it['qty'] ?>
    </span>
    <span><?= number_format($it['price'] * $it['qty']) ?> IQD</span>
</div>
<?php endforeach; ?>

<div class="total">
<?= $tr['total'] ?? 'Total' ?>:
<?= number_format($reservation['total_price']) ?> IQD
</div>

</div>

<a class="btn" href="index.php?lang=<?= $lang ?>">
<?= $tr['back_to_menu'] ?? 'Back to Menu' ?>
</a>

</div>
</body>
</html>
