<?php
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

require_once __DIR__."/includes/db.php";
require_once __DIR__."/includes/security.php";
require_once __DIR__."/includes/auth.php";
require_once __DIR__."/includes/functions.php";

ensure_manager();

/* =========================
   LANGUAGE SWITCH
========================= */
if (isset($_GET['lang']) && in_array($_GET['lang'], ['ar','en','ku'])) {
    $_SESSION['lang'] = $_GET['lang'];
    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

$lang = $_SESSION['lang'] ?? 'ar';
$tr   = require __DIR__."/lang/$lang.php";
$dir  = ($lang === 'ar') ? 'rtl' : 'ltr';

/* =========================
   ROLE & RESTAURANT
========================= */
$role = $_SESSION['manager_role'] ?? 'manager';
$restaurant_id = $_SESSION['restaurant_id'] ?? 0;

$page_title = $tr['dashboard'];
require_once "includes/header.php";

/* =========================
   DATA
========================= */
$restaurant = get_restaurant($restaurant_id);

$branches_count   = fetch_value("SELECT COUNT(*) FROM branches WHERE restaurant_id=?", [$restaurant_id]);
$categories_count = fetch_value("SELECT COUNT(*) FROM categories WHERE restaurant_id=?", [$restaurant_id]);
$items_count      = fetch_value("SELECT COUNT(*) FROM items WHERE restaurant_id=?", [$restaurant_id]);

$visits_today = fetch_value("
    SELECT COUNT(*) FROM visits 
    WHERE restaurant_id=? AND DATE(created_at)=CURDATE()
", [$restaurant_id]);

$visits_total = fetch_value("
    SELECT COUNT(*) FROM visits 
    WHERE restaurant_id=?
", [$restaurant_id]);

$branches = get_branches($restaurant_id);
?>

<style>
/* =====================
   BASE
===================== */
h1,h2,h3{margin-top:0}
.badge{padding:5px 12px;border-radius:6px;font-size:13px}
.green{background:#28a745}
.red{background:#dc3545}

/* =====================
   DASHBOARD GRID
===================== */
.cards{
    display:grid;
    grid-template-columns:repeat(4,1fr);
    gap:20px;
    margin-bottom:30px;
}
.card{
    background:#1c1c1c;
    padding:22px;
    border-radius:12px;
    border:1px solid #333;
}
.card h3{color:#ccc;font-size:16px}
.card .num{font-size:32px;color:#ff7a00;font-weight:bold}

/* =====================
   TABLE
===================== */
.table-box{
    background:#1c1c1c;
    padding:20px;
    border-radius:14px;
    border:1px solid #333;
}
table{width:100%;border-collapse:collapse}
th,td{padding:12px;border-bottom:1px solid #333}
th{background:#222;color:#ff7a00;text-align:right}

/* =====================
   RESPONSIVE (≤ 890px)
===================== */
@media (max-width:890px){
    .cards{
        grid-template-columns:repeat(2,1fr);
    }
}
@media (max-width:520px){
    .cards{
        grid-template-columns:1fr;
    }
}
</style>

<!-- =====================
     HEADER CARD
===================== -->
<div class="card">
    <h2><?= $tr['welcome'] ?> <?= htmlspecialchars($_SESSION['manager_name']) ?> 👋</h2>
    <p>
        <?= $tr['account_type'] ?> :
        <?= $role === 'manager' ? $tr['manager'] : $tr['editor'] ?>
    </p>
</div>

<h1><?= $tr['statistics'] ?></h1>

<!-- =====================
     STATS
===================== -->
<div class="cards">
    <div class="card">
        <h3><?= $tr['branches_count'] ?></h3>
        <div class="num"><?= $branches_count ?></div>
    </div>

    <div class="card">
        <h3><?= $tr['categories_count'] ?></h3>
        <div class="num"><?= $categories_count ?></div>
    </div>

    <div class="card">
        <h3><?= $tr['items_count'] ?></h3>
        <div class="num"><?= $items_count ?></div>
    </div>

    <div class="card">
        <h3><?= $tr['visits_today'] ?></h3>
        <div class="num"><?= $visits_today ?></div>
    </div>
</div>

<div class="cards">
    <div class="card" style="grid-column:span 4">
        <h3><?= $tr['visits_total'] ?></h3>
        <div class="num"><?= $visits_total ?></div>
    </div>
</div>

<!-- =====================
     BRANCHES
===================== -->
<div class="table-box">
    <h2><?= $tr['latest_branches'] ?></h2>
    <table>
        <tr>
            <th><?= $tr['branch_name'] ?></th>
            <th><?= $tr['phone'] ?></th>
            <th><?= $tr['address'] ?></th>
            <th><?= $tr['status'] ?></th>
            <th><?= $tr['actions'] ?></th>
        </tr>

        <?php foreach($branches as $b): ?>
        <tr>
            <td><?= htmlspecialchars($b['name_ar'] ?: $b['name']) ?></td>
            <td><?= htmlspecialchars($b['phone'] ?: '—') ?></td>
            <td><?= htmlspecialchars($b['address'] ?: '—') ?></td>
            <td>
                <span class="badge <?= $b['active'] ? 'green' : 'red' ?>">
                    <?= $b['active'] ? $tr['active'] : $tr['inactive'] ?>
                </span>
            </td>
            <td>
                <a href="branch_edit.php?id=<?= $b['id'] ?>" class="btn-sm">
                    <?= $tr['edit'] ?>
                </a>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>

<?php require_once "includes/footer.php"; ?>
