<?php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . "/db.php";
require_once __DIR__ . "/security.php";
require_once __DIR__ . "/functions.php";

/*
|--------------------------------------------------------------------------
| CHECK LOGIN
|--------------------------------------------------------------------------
*/
function is_logged_in()
{
    return isset($_SESSION['manager_id']);
}

function get_role()
{
    return $_SESSION['manager_role'] ?? "manager"; // manager / editor
}

/*
|--------------------------------------------------------------------------
| REQUIRE LOGIN
|--------------------------------------------------------------------------
*/
function ensure_manager()
{
    if (!is_logged_in()) {
        header("Location: login.php");
        exit;
    }
}

/*
|--------------------------------------------------------------------------
| BLOCK ACCESS TO MANAGER-ONLY PAGES
|--------------------------------------------------------------------------
*/
function ensure_full_manager()
{
    ensure_manager();

    if (get_role() !== "manager") {
        die("
        <h2 style='color:#ff3333;text-align:center;margin-top:40px'>
            لا تملك صلاحيات دخول هذه الصفحة
        </h2>");
    }
}

/*
|--------------------------------------------------------------------------
| LOGIN FUNCTION
|--------------------------------------------------------------------------
*/
function admin_login($email, $password)
{
    $email = clean($email);
    $password = clean($password);

    // Fetch manager by email
    $admin = fetch_one("
        SELECT *
        FROM managers
        WHERE email = ?
        LIMIT 1
    ", [$email]);

    if (!$admin) {
        return false;
    }

    // Password check (old MD5 + new password_hash)
    $old_ok = (md5($password) === $admin['password']);
    $new_ok = password_verify($password, $admin['password']);

    if (!$old_ok && !$new_ok) {
        return false;
    }

    // Safe role fallback
    $role = $admin['role'] ?? "manager";

    // Safe restaurant id
    $restaurant_id = isset($admin['restaurant_id']) ? (int)$admin['restaurant_id'] : 0;

    // Store session
    $_SESSION['manager_id']        = (int)$admin['id'];
    $_SESSION['manager_name']      = $admin['name'];
    $_SESSION['manager_role']      = $role;
    $_SESSION['restaurant_id']     = $restaurant_id;
    $_SESSION['login_time']        = time();

    // Log
    log_action($admin['id'], "login", "Manager logged in");

    return true;
}

/*
|--------------------------------------------------------------------------
| LOGOUT FUNCTION
|--------------------------------------------------------------------------
*/
function admin_logout()
{
    if (!empty($_SESSION['manager_id'])) {
        log_action($_SESSION['manager_id'], "logout", "Manager logged out");
    }

    session_unset();
    session_destroy();

    header("Location: login.php");
    exit;
}
