<?php
require_once __DIR__ . "/auth.php";
ensure_manager();

require_once __DIR__ . "/functions.php";

/* =========================
   ROLE & RESTAURANT
========================= */
$role = $_SESSION['manager_role'] ?? 'manager';
$restaurant_id = $_SESSION['restaurant_id'] ?? 0;

/* =========================
   LANGUAGE SWITCH
========================= */
if (isset($_GET['lang']) && in_array($_GET['lang'], ['ar','en','ku'])) {
    $_SESSION['lang'] = $_GET['lang'];
    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

$lang = $_SESSION['lang'] ?? 'ar';
$dir  = ($lang === 'ar') ? 'rtl' : 'ltr';

/* =========================
   LOAD TRANSLATION FILE
========================= */
$tr = require __DIR__ . "/../lang/$lang.php";

/* =========================
   LOAD RESTAURANT FEATURES
========================= */
$restaurant = fetch_one("
    SELECT reservations_enabled, reports_enabled ,discounts_enabled
    FROM restaurants
    WHERE id = ?
", [$restaurant_id]);

/* =========================
   LOAD RESTAURANT LANGUAGES
========================= */
$restaurant_languages = fetch_all("
    SELECT l.code
    FROM restaurant_languages rl
    JOIN languages l ON l.id = rl.language_id
    WHERE rl.restaurant_id = ? AND rl.active = 1
    ORDER BY l.id ASC
", [$restaurant_id]);

$lang_codes = array_column($restaurant_languages, 'code');

/* أمان */
if (empty($lang_codes)) {
    $lang_codes = ['ar'];
}

if (!in_array($lang, $lang_codes)) {
    $lang = $lang_codes[0];
    $_SESSION['lang'] = $lang;
}
?>
<!DOCTYPE html>
<html lang="<?= $lang ?>" dir="<?= $dir ?>">
<head>
<meta charset="UTF-8">
<title><?= $page_title ?? $tr['dashboard'] ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
body{
    margin:0;
    padding:0;
    font-family:"Tajawal", sans-serif;
    background:#111;
    color:#fff;
}

/* SIDEBAR */
.sidebar{
    width:250px;
    height:100vh;
    background:#000;
    position:fixed;
    top:0;
    <?= $dir === 'rtl' ? 'right:0;' : 'left:0;' ?>
    padding:25px;
    border-<?= $dir === 'rtl' ? 'left' : 'right' ?>:1px solid #222;
    overflow-y:auto;
}

.sidebar h3{
    margin:0 0 15px 0;
    font-size:20px;
    color:#ff7a00;
}

/* LANGUAGE SWITCH */
.lang-switch{
    display:flex;
    gap:6px;
    margin-bottom:20px;
}
.lang-switch a{
    flex:1;
    text-align:center;
    padding:6px;
    border-radius:6px;
    background:#222;
    color:#fff;
    text-decoration:none;
    font-size:13px;
}
.lang-switch a.active{
    background:#ff7a00;
    color:#000;
    font-weight:bold;
}

/* LINKS */
.sidebar a{
    display:block;
    padding:12px 15px;
    margin:7px 0;
    color:#fff;
    text-decoration:none;
    background:#1a1a1a;
    border-radius:8px;
    font-size:15px;
    transition:0.2s;
}

.sidebar a:hover{
    background:#ff7a00;
    color:#000;
}

.sidebar .logout{
    background:#a00;
}
.sidebar .logout:hover{
    background:#d00;
}

/* CONTENT */
.content{
    margin-<?= $dir === 'rtl' ? 'right' : 'left' ?>:280px;
    padding:30px;
}
</style>
</head>
<body>

<div class="sidebar">

    <h3><?= $tr['admin_panel'] ?></h3>

    <!-- Language Switch -->
    <div class="lang-switch">
        <?php foreach ($lang_codes as $lc): ?>
            <a href="?lang=<?= $lc ?>" class="<?= $lang == $lc ? 'active' : '' ?>">
                <?= strtoupper($lc) ?>
            </a>
        <?php endforeach; ?>
    </div>

    <!-- =====================
         EDITOR + MANAGER
    ====================== -->
    <a href="dashboard.php"><?= $tr['dashboard'] ?></a>
    <a href="menu_builder.php"><?= $tr['menu'] ?></a>
    <a href="banners.php"><?= $tr['banners'] ?></a>
    <?php if (!empty($restaurant['discounts_enabled'])): ?>
             <a href="discounts.php"><?= $tr['discounts'] ?></a>
        <?php endif; ?>
   

    <?php if ($role === "manager"): ?>
        <!-- =====================
             MANAGER ONLY
        ====================== -->
        <a href="settings.php"><?= $tr['settings'] ?></a>
        <a href="branches.php"><?= $tr['branches'] ?></a>
        <a href="social.php"><?= $tr['social'] ?></a>

        <?php if (!empty($restaurant['reservations_enabled'])): ?>
            <a href="reservations.php"><?= $tr['reservations'] ?></a>
        <?php endif; ?>

        <?php if (!empty($restaurant['reports_enabled'])): ?>
            <a href="reports.php"><?= $tr['reports'] ?></a>
        <?php endif; ?>

        <a href="users.php"><?= $tr['users'] ?></a>
    <?php endif; ?>

    <a href="logout.php" class="logout"><?= $tr['logout'] ?></a>

</div>

<div class="content">
<script>
window.LIVE_NOTIFY_ENABLED = <?= (int)($_SESSION['live_notify'] ?? 0) ?>;
window.NOTIFY_SOUND_URL = "/menu/manager/assets/notify.mp3"; // مهم: مسار ثابت
</script>
<script src="assets/live.js"></script>
