<?php

/*
|--------------------------------------------------------------------------
| UPLOAD FILE (IMAGE / VIDEO)
|--------------------------------------------------------------------------
| usage:
| $new = upload_file($_FILES['logo'], "restaurants");
| $new = upload_file($_FILES['cover_video'], "branches", ['mp4']);
|--------------------------------------------------------------------------
*/

function upload_file($file, $folder, $allowed = ['jpg', 'jpeg', 'png', 'webp', 'mp4'])
{
    if (!isset($file) || !$file['name']) {
        return null;
    }

    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

    // check allowed types
    if (!in_array($ext, $allowed)) {
        return null;
    }

    // create folder if not exists
    $target_folder = "../uploads/" . $folder . "/";
    if (!file_exists($target_folder)) {
        mkdir($target_folder, 0777, true);
    }

    // generate safe filename
    $new_name = uniqid("f_") . "." . $ext;
    $full_path = $target_folder . $new_name;

    // move file
    if (move_uploaded_file($file['tmp_name'], $full_path)) {
        return "uploads/" . $folder . "/" . $new_name;
    }

    return null;
}


/*
|--------------------------------------------------------------------------
| UPDATE FILE (Upload new + Delete old)
|--------------------------------------------------------------------------
| usage:
| $new_logo = update_file($_FILES["logo"], $restaurant["logo"], "restaurants");
|--------------------------------------------------------------------------
*/

function update_file($file, $old_path, $folder, $allowed = ['jpg', 'jpeg', 'png', 'webp', 'mp4'])
{
    // no new file uploaded
    if (!$file['name']) {
        return $old_path;
    }

    // upload new file
    $new_file = upload_file($file, $folder, $allowed);

    if ($new_file && $old_path && file_exists("../" . $old_path)) {
        @unlink("../" . $old_path);
    }

    return $new_file ?: $old_path;
}


/*
|--------------------------------------------------------------------------
| DELETE FILE
|--------------------------------------------------------------------------
*/

function delete_file($path)
{
    if ($path && file_exists("../" . $path)) {
        @unlink("../" . $path);
    }
}

