<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once "includes/auth.php";
require_once "includes/security.php";

/* =========================================
   تفعيل الاشعارات تلقائياً عند تسجيل الدخول
   (جلسة + كوكي اختياري)
========================================= */
function enable_live_notify($remember = false){
    $_SESSION['live_notify'] = 1;
    if ($remember) {
        // نفس مدة remember (30 يوم)
        setcookie("live_notify", "1", time() + (60*60*24*30), "/");
    }
}

/* =========================================
   تسجيل دخول تلقائي من الكوكي
========================================= */
if (!is_logged_in() && isset($_COOKIE['remember_email'], $_COOKIE['remember_password'])) {

    $email    = $_COOKIE['remember_email'];
    $password = $_COOKIE['remember_password'];

    if (admin_login($email, $password)) {
        // فعّل الاشعارات مباشرة
        enable_live_notify(true);

        header("Location: dashboard.php");
        exit;
    }
}

// لو المدير مسجل دخول → مباشرة للوحة التحكم
if (is_logged_in()) {
    // إذا لأي سبب ما كانت مفعلة، فعّلها تلقائياً
    if (empty($_SESSION['live_notify']) && (!empty($_COOKIE['live_notify']) && $_COOKIE['live_notify'] == "1")) {
        $_SESSION['live_notify'] = 1;
    } elseif (empty($_SESSION['live_notify'])) {
        // افتراضياً فعّلها عند أي دخول
        $_SESSION['live_notify'] = 1;
    }

    header("Location: dashboard.php");
    exit;
}

$error = "";

// عند الضغط على زر تسجيل الدخول
if ($_SERVER['REQUEST_METHOD'] === "POST") {

    $email    = clean($_POST['email']);
    $password = clean($_POST['password']);
    $remember = isset($_POST['remember']);

    if (admin_login($email, $password)) {

        // حفظ تسجيل الدخول
        if ($remember) {
            setcookie("remember_email", $email, time() + (60*60*24*30), "/");
            setcookie("remember_password", $password, time() + (60*60*24*30), "/");
        }

        // فعّل الاشعارات تلقائياً عند تسجيل الدخول
        enable_live_notify($remember);

        header("Location: dashboard.php");
        exit;

    } else {
        $error = "بيانات الدخول غير صحيحة";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تسجيل الدخول</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
body{
    margin:0;
    background:#111;
    color:#fff;
    font-family:"Tajawal",sans-serif;
}
.login-box{
    width:350px;
    margin:120px auto;
    background:#1c1c1c;
    padding:30px;
    border-radius:12px;
    box-shadow:0 0 12px rgba(0,0,0,0.5);
}
.login-box h2{
    margin:0 0 20px 0;
    text-align:center;
}
input{
    width:100%;
    padding:12px;
    margin-top:10px;
    border-radius:8px;
    border:none;
    font-size:16px;
}
.remember{
    margin-top:12px;
    font-size:14px;
}
.remember input{
    width:auto;
    margin-left:5px;
}
button{
    width:100%;
    padding:12px;
    margin-top:15px;
    background:#ff7a00;
    border:none;
    color:#000;
    font-weight:bold;
    border-radius:8px;
    cursor:pointer;
    font-size:16px;
}
button:hover{
    opacity:0.9;
}
.error{
    background:#a00;
    padding:10px;
    margin-top:10px;
    border-radius:6px;
    color:#fff;
    text-align:center;
}
</style>
</head>

<body>

<div class="login-box">
    <h2>تسجيل الدخول</h2>

    <?php if($error): ?>
        <div class="error"><?= $error ?></div>
    <?php endif; ?>

    <form method="post">
        <input type="email" name="email" placeholder="البريد الإلكتروني" required>
        <input type="password" name="password" placeholder="كلمة المرور" required>

        <div class="remember">
            <label>
                <input type="checkbox" name="remember">
                حفظ تسجيل الدخول
            </label>
        </div>

        <button type="submit">دخول</button>
    </form>
</div>

</body>
</html>
