<?php
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

require_once __DIR__."/includes/db.php";
require_once __DIR__."/includes/security.php";
require_once __DIR__."/includes/auth.php";
require_once __DIR__."/includes/functions.php";

ensure_manager();

$page_title = "إعدادات المطعم";
require_once "includes/header.php";

$restaurant_id = $_SESSION['restaurant_id'];

// جلب بيانات المطعم
$rest = get_restaurant($restaurant_id) ?: [];
foreach ($rest as $k=>$v) if (is_null($v)) $rest[$k] = "";

// قيم افتراضية
$rest = array_merge([
    "name"=>"","name_en"=>"","name_ku"=>"",
    "phone"=>"","whatsapp"=>"","facebook"=>"","instagram"=>"","location"=>"",
    "logo"=>"","cover_image"=>"","background_image"=>"","background_video"=>"",
    "primary_color"=>"#ff7a00","secondary_color"=>"#000000",
    "mode"=>"dark","grid_mode"=>2
], $rest);

// حذف صور معينة (اسم فقط)
if (isset($_GET['del']) && in_array($_GET['del'], ['logo','cover_image','background_image','background_video'])) {
    $key = $_GET['del'];
    delete_file($rest[$key]);
    update_restaurant_settings($restaurant_id, [$key=> ""]);
    header("Location: settings.php?saved=1");
    exit;
}

// حفظ الإعدادات
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['save_settings'])) {

    $rest['name']       = $_POST['name'] ?? "";
    $rest['name_en']    = $_POST['name_en'] ?? "";
    $rest['name_ku']    = $_POST['name_ku'] ?? "";
    $rest['phone']      = $_POST['phone'] ?? "";
    $rest['whatsapp']   = $_POST['whatsapp'] ?? "";
    $rest['facebook']   = $_POST['facebook'] ?? "";
    $rest['instagram']  = $_POST['instagram'] ?? "";
    $rest['location']   = $_POST['location'] ?? "";

    $rest['mode']            = $_POST['mode'] ?? 'dark';
    $rest['primary_color']   = $_POST['primary_color'] ?? '#ff7a00';
    $rest['secondary_color'] = $_POST['secondary_color'] ?? '#000000';
    $rest['grid_mode']       = (int)($_POST['grid_mode'] ?? 2);

  // رفع وإرجاع اسم فقط
$rest['logo']             = upload_custom("logo", "Logo", $rest['logo']);
$rest['cover_image']      = upload_custom("cover_image", "Banners", $rest['cover_image']);
$rest['background_image'] = upload_custom("background_image", "MenuBG", $rest['background_image']);
$rest['background_video'] = upload_custom("background_video", "Videos", $rest['background_video']);

update_restaurant_settings($restaurant_id, $rest);
header("Location: settings.php?saved=1");
exit;
}

// حذف الحساب بالكامل
if (isset($_POST['delete_account'])) {
    delete_restaurant_account($restaurant_id, $_SESSION['manager_id']);
    header("Location: ../login.php");
    exit;
}
?>

<style>
.settings-card{
    background:#1c1c1c;padding:20px;border-radius:12px;border:1px solid #333;margin-bottom:25px;
}
.settings-card h3{color:#ffbe6a;margin-top:0;font-weight:600;border-bottom:1px solid #444;padding-bottom:6px;}
input, textarea, select{
    width:100%;padding:10px;border-radius:7px;background:#111;border:1px solid #444;color:#fff;margin-top:6px;
}
.preview-box{display:flex;align-items:center;gap:10px;margin:8px 0;}
.preview-img, .preview-video{width:140px;height:140px;border:1px solid #333;border-radius:10px;object-fit:cover;background:#000;}
.btn-del{background:#e30000;color:#fff;padding:6px 12px;border-radius:6px;font-size:12px;text-decoration:none;}
.btn-save{background:#ff7a00;color:#fff;padding:12px 22px;border:none;border-radius:10px;font-size:16px;cursor:pointer;}
.btn-delete-account{background:#b00000;color:#fff;padding:12px 22px;border:none;border-radius:10px;font-size:16px;cursor:pointer;margin-right:10px;}
.msg-success{background:#13a813;padding:12px;border-radius:10px;color:#fff;margin-bottom:12px;text-align:center;}
.section-title{color:#fff;font-size:18px;margin-top:25px;font-weight:bold;border-right:3px solid #ff7a00;padding-right:8px;}
</style>

<div class="settings-card">

    <h3>إعدادات المطعم</h3>
    <?php if(isset($_GET['saved'])): ?><div class="msg-success">تم حفظ الإعدادات بنجاح</div><?php endif; ?>

    <form method="post" enctype="multipart/form-data">

        <!-- الهوية -->
        <div class="section-title">الهوية</div>
        <label>اسم المطعم (عربي)</label>
        <input type="text" name="name" value="<?= htmlspecialchars($rest['name']) ?>">

        <label>اسم المطعم (EN)</label>
        <input type="text" name="name_en" value="<?= htmlspecialchars($rest['name_en']) ?>">

        <label>اسم المطعم (Kurdî)</label>
        <input type="text" name="name_ku" value="<?= htmlspecialchars($rest['name_ku']) ?>">

        <!-- الصور -->
        <div class="section-title">الصور</div>

        <!-- Logo -->
        <label>Logo</label>
        <?php if($rest['logo']): ?>
        <div class="preview-box">
            <img src="/menu/uploads/Logo/<?= $rest['logo'] ?>" class="preview-img">
            <a class="btn-del" href="settings.php?del=logo">حذف</a>
        </div>
        <?php endif; ?>
        <input type="file" name="logo" accept="image/*">

       
        <!-- Background Image -->
        <label>خلفية المنيو (MenuBG)</label>
        <?php if($rest['background_image']): ?>
        <div class="preview-box">
            <img src="/menu/uploads/MenuBG/<?= $rest['background_image'] ?>" class="preview-img">
            <a class="btn-del" href="settings.php?del=background_image">حذف</a>
        </div>
        <?php endif; ?>
        <input type="file" name="background_image" accept="image/*">

        <!-- Background Video -->
        <label>خلفية فيديو (Videos)</label>
        <?php if($rest['background_video']): ?>
        <div class="preview-box">
            <video class="preview-video" autoplay muted loop>
                <source src="/menu/uploads/Videos/<?= $rest['background_video'] ?>">
            </video>
            <a class="btn-del" href="settings.php?del=background_video">حذف</a>
        </div>
        <?php endif; ?>
        <input type="file" name="background_video" accept="video/*">

        <!-- الألوان والثيم -->
        <div class="section-title">الألوان والثيم</div>

        <label>الوضع</label>
        <select name="mode">
            <option value="light" <?= $rest['mode']=='light'?'selected':'' ?>>Light</option>
            <option value="dark"  <?= $rest['mode']=='dark'?'selected':'' ?>>Dark</option>
        </select>

        <label>Primary Color</label>
        <input type="color" name="primary_color" value="<?= $rest['primary_color'] ?>">

        <label>Secondary Color</label>
        <input type="color" name="secondary_color" value="<?= $rest['secondary_color'] ?>">

        <label>Grid Mode (عدد الأعمدة)</label>
        <input type="number" name="grid_mode" min="1" max="6" value="<?= (int)$rest['grid_mode'] ?>">

     
        <button class="btn-save" name="save_settings">حفظ الإعدادات</button>
        <button class="btn-delete-account" name="delete_account" onclick="return confirm('هل تريد حذف الحساب بالكامل؟')">حذف الحساب بالكامل</button>

    </form>
</div>

<?php require_once "includes/footer.php"; ?>
