<?php
require_once __DIR__ . "/includes/auth.php";
ensure_super_admin();

require_once __DIR__ . "/includes/functions.php";

$id = (int)($_GET['id'] ?? 0);
$restaurant = fetch_one("SELECT * FROM restaurants WHERE id = ?", [$id]);

if (!$restaurant) {
    die("<h2 style='color:red;text-align:center;margin-top:40px'>المطعم غير موجود</h2>");
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>حذف مطعم</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
body{
    background:#0f0f11;
    color:#fff;
    font-family:Tajawal;
    padding:40px;
    text-align:center;
}
.box{
    background:#1c1c22;
    width:600px;
    margin:auto;
    padding:30px;
    border-radius:12px;
    border:1px solid #2e2e38;
}
.box h2{
    color:#ff4d4d;
}
.btn-delete{
    background:#ff4d4d;
    border:none;
    padding:14px 30px;
    border-radius:8px;
    color:#000;
    font-size:18px;
    cursor:pointer;
    margin-top:25px;
    font-weight:bold;
}
.btn-cancel{
    background:#666;
    padding:12px 25px;
    border-radius:8px;
    color:#fff;
    text-decoration:none;
    margin-top:20px;
    display:inline-block;
}
.warning{
    background:#330000;
    border:1px solid #660000;
    padding:15px;
    border-radius:8px;
    margin-bottom:20px;
}
</style>

</head>
<body>

<div class="box">
    <h2>حذف مطعم: <?= htmlspecialchars((string)$restaurant['name']) ?></h2>

    <div class="warning">
        <h3>تحذير: عملية لا يمكن التراجع عنها</h3>
        سيتم حذف:
        <ul style="text-align:right;line-height:2;">
            <li><b>ملف واجهة المطعم فقط</b> (مجلد المطعم) حسب <b>folder_name</b></li>
            <li><b>بيانات هذا المطعم فقط من قاعدة البيانات</b> (كل السجلات المرتبطة بـ <b>restaurant_id</b>)</li>
        </ul>
        <div style="text-align:right;margin-top:10px;color:#ffd1d1">
            ملاحظة: لن يتم حذف ملفات uploads المشتركة (صور البانرات/الأصناف… كملفات على السيرفر). فقط يتم حذف مجلد الواجهة الخاص بالمطعم.
        </div>
    </div>

    <form action="restaurant_delete_action.php" method="POST">
        <input type="hidden" name="id" value="<?= (int)$id ?>">

        <button class="btn-delete" onclick="return confirm('هل أنت متأكد من الحذف النهائي؟')">
            حذف المطعم نهائياً
        </button>
    </form>

    <a href="restaurants.php" class="btn-cancel">عودة</a>
</div>

</body>
</html>
