<?php
// super_admin/includes/auth.php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . "/db.php";
require_once __DIR__ . "/functions.php";

/*
|---------------------------------------------------------------------------
| CHECK SUPER ADMIN LOGIN
|---------------------------------------------------------------------------
*/

function is_super() {
    return isset($_SESSION['super_id']);
}

function require_super() {
    if (!is_super()) {
        header("Location: login.php");
        exit;
    }
}

/*
|--------------------------------------------------------------------------
| CHECK LOGIN
|--------------------------------------------------------------------------
*/
function is_super_admin()
{
    return isset($_SESSION['super_id']);
}

function ensure_super_admin()
{
    if (!is_super_admin()) {
        header("Location: login.php");
        exit;
    }
}

/*
|--------------------------------------------------------------------------
| LOGIN FUNCTION
|--------------------------------------------------------------------------
*/
function super_login($email, $password)
{
    $u = fetch_one("SELECT * FROM users WHERE email = ? LIMIT 1", [$email]);

    if (!$u) return false;

    $is_old = md5($password) === $u['password'];
    $is_new = password_verify($password, $u['password']);

    if (!$is_old && !$is_new) return false;

    $_SESSION['super_id']    = $u['id'];
    $_SESSION['super_name']  = $u['name'];
    $_SESSION['super_role']  = "super_admin";

    return true;
}

/*
|--------------------------------------------------------------------------
| LOGOUT
|--------------------------------------------------------------------------
*/
function super_logout()
{
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
