<?php
require_once __DIR__ . "/auth.php";
ensure_super_admin();

// LANGUAGE TOGGLE
if (isset($_GET['set_lang'])) {
    $_SESSION['lang'] = $_GET['set_lang'] === "en" ? "en" : "ar";
    header("Location: " . strtok($_SERVER["REQUEST_URI"],'?'));
    exit;
}

$lang = $_SESSION['lang'] ?? "ar";
include __DIR__ . "/lang_$lang.php";
$dir = $lang === "ar" ? "rtl" : "ltr";
?>
<!DOCTYPE html>
<html lang="<?= $lang ?>" dir="<?= $dir ?>">
<head>
<meta charset="UTF-8">
<title><?= $t['panel_title'] ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
:root{
    --primary:#8A2BE2;
    --bg:#111;
    --bg-card:#1c1c1c;
    --text:#fff;
}

body{
    margin:0;
    padding:0;
    background:var(--bg);
    color:var(--text);
    font-family:"Tajawal",sans-serif;
    display:flex;
}

/* CONTENT */
.content{
    flex:1;
    padding:30px;
}

/* CARDS */
.card{
    background:var(--bg-card);
    padding:20px;
    border-radius:12px;
    margin-bottom:20px;
    border:1px solid #222;
}

.btn{
    background:var(--primary);
    color:#fff;
    padding:10px 20px;
    border-radius:8px;
    text-decoration:none;
    border:none;
    cursor:pointer;
}
.btn:hover{ opacity:0.8; }

/* LANGUAGE SWITCH BUTTON */
.lang-switch{
    position:fixed;
    top:20px;
    <?= $dir === "rtl" ? "left:20px;" : "right:20px;" ?>
    z-index:9999;
}
.lang-switch a{
    display:inline-block;
    padding:8px 14px;
    background:var(--primary);
    color:#fff;
    border-radius:25px;
    font-size:14px;
    text-decoration:none;
    font-weight:bold;
}
.lang-switch a:hover{ opacity:0.8; }

</style>
</head>

<body>

<!-- LANGUAGE SWITCH BUTTON -->
<div class="lang-switch">
    <?php if ($lang === "ar"): ?>
        <a href="?set_lang=en">EN</a>
    <?php else: ?>
        <a href="?set_lang=ar">AR</a>
    <?php endif; ?>
</div>

<?php include __DIR__ . "/sidebar.php"; ?>

<div class="content">
