<?php
require_once __DIR__ . "/includes/auth.php";

if (is_super_admin()) {
    header("Location: index.php");
    exit;
}

$lang = $_SESSION['lang'] ?? "ar";
include __DIR__ . "/includes/lang_$lang.php";
$dir = $lang === "ar" ? "rtl" : "ltr";

$error = "";

if ($_SERVER['REQUEST_METHOD'] === "POST") {

    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    if (super_login($email, $password)) {
        header("Location: index.php");
        exit;
    } else {
        $error = ($lang === "ar")
            ? "بيانات الدخول غير صحيحة"
            : "Invalid login credentials";
    }
}

?>
<!DOCTYPE html>
<html lang="<?= $lang ?>" dir="<?= $dir ?>">
<head>
<meta charset="UTF-8">
<title><?= $t['panel_title'] ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
:root{
    --primary:#8A2BE2;
    --bg:#111;
    --card:#1c1c1c;
    --text:#fff;
}

body{
    margin:0;
    background:var(--bg);
    color:var(--text);
    font-family:"Tajawal",sans-serif;
}

.login-box{
    width:350px;
    margin:130px auto;
    background:var(--card);
    padding:35px;
    border-radius:12px;
    box-shadow:0 0 12px rgba(0,0,0,0.6);
    text-align:center;
}

h2{
    margin:0 0 20px 0;
    color:var(--primary);
}

input{
    width:100%;
    padding:12px;
    margin-top:12px;
    border-radius:8px;
    border:none;
    background:#222;
    color:#fff;
    font-size:15px;
}

button{
    width:100%;
    padding:12px;
    margin-top:18px;
    background:var(--primary);
    border:none;
    color:#fff;
    font-size:16px;
    font-weight:bold;
    border-radius:8px;
    cursor:pointer;
}
button:hover{
    opacity:0.85;
}

.error{
    background:#a00;
    padding:10px;
    margin-top:15px;
    border-radius:8px;
    color:#fff;
    font-size:14px;
}

.lang-switch{
    text-align:center;
    margin-top:15px;
}
.lang-switch a{
    color:var(--primary);
    text-decoration:none;
    font-weight:bold;
}
</style>

</head>
<body>

<div class="login-box">

    <h2><?= $t['panel_title'] ?></h2>

    <?php if ($error): ?>
        <div class="error"><?= $error ?></div>
    <?php endif; ?>

    <form method="post">
        <input type="email" name="email"
               placeholder="<?= $lang === 'ar' ? 'البريد الإلكتروني' : 'Email' ?>" required>

        <input type="password" name="password"
               placeholder="<?= $lang === 'ar' ? 'كلمة المرور' : 'Password' ?>" required>

        <button type="submit">
            <?= $lang === "ar" ? "دخول" : "Login" ?>
        </button>
    </form>

    <div class="lang-switch">
        <?php if ($lang === "ar"): ?>
            <a href="?set_lang=en">ENGLISH</a>
        <?php else: ?>
            <a href="?set_lang=ar">العربية</a>
        <?php endif; ?>
    </div>

</div>

</body>
</html>
