<?php
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

require_once __DIR__ . "/includes/auth.php";
ensure_super_admin();
require_once __DIR__ . "/includes/functions.php";

$id = intval($_GET['id']);
$rest = get_restaurant($id);

if (!$rest) {
    die("<h2 style='color:red;text-align:center'>مطعم غير موجود</h2>");
}

// معالجة الحفظ
if ($_SERVER['REQUEST_METHOD'] === "POST") {

    $subscription_type = $_POST['subscription_type'];
    $subscription_days = intval($_POST['subscription_days']);
    
    // حساب تاريخ البداية والنهاية
    $start = date("Y-m-d");
    if ($subscription_type === "monthly") {
        $end = date("Y-m-d", strtotime("+30 days"));
    } elseif ($subscription_type === "yearly") {
        $end = date("Y-m-d", strtotime("+365 days"));
    } else {
        $end = date("Y-m-d", strtotime("+$subscription_days days"));
    }

    db()->prepare("
        UPDATE restaurants 
        SET subscription_type=?, subscription_start=?, subscription_end=?, active=1
        WHERE id=?
    ")->execute([$subscription_type,$start,$end,$id]);

    header("Location: subscriptions.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تعديل اشتراك</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{
    margin:0; padding:0; background:#0f0f11;
    font-family:"Tajawal",sans-serif; color:#fff; display:flex;
}
.content{
    margin-right:300px; padding:35px; width:100%;
}
.box{
    background:#1b1b22; padding:25px; border-radius:12px;
    border:1px solid #2a2933; width:400px;
}
.box h3{
    color:#9c6bff; margin-top:0; margin-bottom:25px;
    text-align:center;
}
input, select{
    width:100%; padding:10px; border-radius:8px;
    border:none; margin-bottom:15px; background:#26252f;
    color:#fff;
}
.btn-primary{
    background:#9c6bff; padding:10px; width:100%;
    border:none; border-radius:8px; cursor:pointer;
    color:#000; font-weight:bold; font-size:16px;
}
.btn-primary:hover{ opacity:0.85; }
</style>
</head>
<body>

<?php include "includes/sidebar.php"; ?>
<div class="content">

<div class="box">
<h3>تعديل اشتراك: <?= $rest['name'] ?></h3>

<form method="post">

<label>نوع الاشتراك:</label>
<select name="subscription_type" id="sub_type" onchange="toggleDays()">
    <option value="monthly" <?= $rest['subscription_type']=="monthly"?"selected":"" ?>>شهري</option>
    <option value="yearly" <?= $rest['subscription_type']=="yearly"?"selected":"" ?>>سنوي</option>
    <option value="custom" <?= $rest['subscription_type']=="custom"?"selected":"" ?>>مخصص</option>
</select>

<div id="days_box" style="display:none;">
    <label>عدد الأيام:</label>
    <input type="number" name="subscription_days" min="1" placeholder="مثال: 45">
</div>

<button class="btn-primary">حفظ الاشتراك</button>

</form>
</div>

</div>

<script>
function toggleDays(){
    let type = document.getElementById("sub_type").value;
    document.getElementById("days_box").style.display = (type==="custom") ? "block" : "none";
}
toggleDays();
</script>

</body>
</html>
