<?php
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

require_once __DIR__ . "/includes/auth.php";
ensure_super_admin();

require_once __DIR__ . "/includes/functions.php";

// جلب جميع الاشتراكات مع بيانات المطعم
$subs = fetch_all("
    SELECT r.id, r.name, r.subscription_type, r.subscription_start, r.subscription_end, r.active,
    (SELECT COUNT(*) FROM branches b WHERE b.restaurant_id = r.id) AS branch_count
    FROM restaurants r
    ORDER BY r.subscription_end ASC
");

// دالة لون الحالة
function sub_color($days)
{
    if ($days < 10) return "red";
    if ($days < 20) return "yellow";
    return "green";
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إدارة الاشتراكات</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
body{
    margin:0; padding:0; background:#0f0f11;
    font-family:"Tajawal",sans-serif; color:#fff; display:flex;
}
.content{
    margin-right:300px;
    padding:35px;
    width:100%;
}
.section-title{
    font-size:24px; margin-bottom:20px; color:#9c6bff;
}
.table-box{
    margin-top:30px;
    background:#1b1b22;
    padding:20px;
    border-radius:12px;
    border:1px solid #2a2933;
}
table{
    width:100%;
    border-collapse:collapse;
}
th, td{
    padding:12px; border-bottom:1px solid #2a2933;
}
th{
    background:#26252f; color:#9c6bff; text-align:right;
}
.badge{ padding:6px 10px; border-radius:6px; color:#000; font-weight:bold; }
.red{ background:#ff4f4f; }
.yellow{ background:#ffe15d; }
.green{ background:#73ff81; }
.btn-sm{
    padding:6px 12px; background:#9c6bff; color:#000;
    text-decoration:none; border-radius:6px; font-weight:bold;
}
.btn-sm:hover{ opacity:0.85; }
.btn-danger{
    background:#ff4f4f; color:#000 !important;
}
.toggle-btn{
    border:none;
    cursor:pointer;
    padding:6px 12px;
    border-radius:6px;
    font-weight:bold;
    color:#000;
}

</style>
</head>


<body>

<?php include "includes/sidebar.php"; ?>

<div class="content">

<h2 class="section-title">إدارة الاشتراكات</h2>

<div class="table-box">
<table>
<tr>
    <th>المطعم</th>
    <th>عدد الفروع</th>
    <th>نوع الاشتراك</th>
    <th>بداية الاشتراك</th>
    <th>نهاية الاشتراك</th>
    <th>الأيام المتبقية</th>
    <th>الحالة</th>
    <th>تحكم</th>
</tr>

<?php foreach ($subs as $r): ?>
<?php
$days = 0;
if (!empty($r['subscription_end'])) {
    $end = strtotime($r['subscription_end']);
    if ($end) {
        $days = ceil(($end - time()) / 86400);
        if ($days < 0) $days = 0;
    }
} else {
    $days = 0;
}
$color = sub_color($days);

?>
<tr>
    <td><?= $r['name'] ?></td>
    <td><?= $r['branch_count'] ?></td>
    <td><?= $r['subscription_type'] ?></td>
    <td><?= $r['subscription_start'] ?: "—" ?></td>
    <td><?= $r['subscription_end'] ?: "—" ?></td>
    <td><span class="badge <?= sub_color($days) ?>"><?= $days ?> يوم</span></td>

    <td>
       <td>
    <button class="toggle-btn <?= $r['active'] ? 'green' : 'red' ?>"
        onclick="toggleStatus(<?= $r['id'] ?>)">
        <?= $r['active'] ? 'فعال' : 'متوقف' ?>
    </button>
</td>

    </td>

    <td>
        <a href="subscription_edit.php?id=<?= $r['id'] ?>" class="btn-sm">تعديل</a>
        <a href="subscription_delete.php?id=<?= $r['id'] ?>" class="btn-sm btn-danger">حذف</a>
    </td>
</tr>
<?php endforeach; ?>

</table>
</div>

</div>

</body>
<script>
function toggleStatus(id){
    fetch("toggle_subscription_status.php", {
        method: "POST",
        headers: {"Content-Type":"application/x-www-form-urlencoded"},
        body: "id="+id
    })
    .then(res=>res.text())
    .then(res=>location.reload());
}
</script>
</html>
